///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifndef _NSWFL_MEMORY_CPP_
#define _NSWFL_MEMORY_CPP_
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <StdIO.H>
#include <StdLib.H>

#include "NSWFL.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void *Allocate(int iBlockSz)
{
    return (void *) calloc(iBlockSz, 1);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Free(void *vBuffer)
{
    if(vBuffer == NULL)
	{
		return false;
	}
    free(vBuffer);
    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void *ClearMem(void *vBuffer, int iBufSz)
{
    for(int iWPos = 0; iWPos < iBufSz; iWPos++)
    {
        ((char *)vBuffer)[iWPos] = 0;
    }

    return vBuffer;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Destroys the given key by overwriting it with random data before initializing it to 0's.
*/
void NukeMem(void *pBuf, size_t iBufSz)
{
	if(pBuf)
	{
		srand(GetTickCount());

		int iRand = rand();

		for(size_t iWPos = 0; iWPos < iBufSz; iWPos++)
		{
			while(!(iRand = rand()))
			{
				//Create non-zero random value.
			}

			for(size_t iRPos = 3; iRPos != -1; iRPos--)
			{
				//The last set operation will set byte to Zero (Rand * 0).
				((BYTE *)pBuf)[iRPos] = (BYTE) (iRand * iRPos);
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	See overload NukeMem()
*/
void NukeMem(char *sBuf)
{
	NukeMem(sBuf, strlen(sBuf));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void *MemCopy(void *vTarget, void *vSource, int iLen)
{
	for(int iPos = 0; iPos < iLen; iPos++)
	{
		((char *)vTarget)[iPos] = ((char *)vSource)[iPos];
	}
    return vTarget;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int MemCopyLong(char *sOutBuf, long lIn)
{
    int iWPos = 0;

	long lBuf = 0;

    if(lIn < 0)
    {
        lBuf = (0 - lIn);
    }
    else lBuf = lIn;

	do
	{
		sOutBuf[iWPos++] = '0' + (int) (lBuf % 10);
		lBuf /= 10;
	}
	while(lBuf != 0);

    if(lIn < 0)
    {
		sOutBuf[iWPos++] = '-';
	}

	ReverseString(sOutBuf, iWPos);

	sOutBuf[iWPos] = '\0';

    return iWPos;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int MemCopyInt(char *sOutBuf, int iIn)
{
    return MemCopyLong(sOutBuf, (long) iIn);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
